VERSION 5.00
Begin VB.UserControl A_Seek 
   ClientHeight    =   1170
   ClientLeft      =   0
   ClientTop       =   0
   ClientWidth     =   3885
   ScaleHeight     =   1170
   ScaleWidth      =   3885
   Begin VB.CommandButton bt_search 
      Caption         =   "..."
      Height          =   270
      Left            =   2985
      TabIndex        =   1
      Top             =   30
      Width           =   255
   End
   Begin VB.TextBox txt_search 
      Height          =   330
      Left            =   0
      TabIndex        =   0
      Top             =   0
      Width           =   3270
   End
End
Attribute VB_Name = "A_Seek"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Option Explicit
'what is new
'2.7.3 Default Country settings (JN)

'Curseur & donnes
Private mo_ArmDb As Object
Private mb_Created As Boolean
Private mb_use_framework_connection As Boolean
Private ms_ConnectString As String
Private ms_UID As String

Private m_Language As String

Private ms_ComponentType As String
Private ms_SelectedItemCode As String
Private ms_SelectedItemDesc As String
Private ms_defaultCountry As String

Private mi_Charset As Integer

Public Event Change()

Public Property Set ArmDb(ByRef ao_local_connection As Object)
    
    #If CapDebug Then
        If Not go_Trace Is Nothing Then go_Trace.WriteTraceProc True, "A_Seek:ArmDb_Set"
    #End If
    CapMouseOff
    
    If Not (ao_local_connection Is Nothing) Then
        
        Set mo_ArmDb = ao_local_connection
        mb_use_framework_connection = True
        
    End If

Trace_End:
    #If CapDebug Then
        If Not go_Trace Is Nothing Then go_Trace.WriteTraceProc False, "A_Seek:ArmDb_Set"
    #End If
    CapMouseOn
End Property

Public Property Get DefaultCountry() As String
    DefaultCountry = ms_defaultCountry
End Property

Public Property Let DefaultCountry(ByVal as_defaultCountry As String)
    #If CapDebug Then
        If Not go_Trace Is Nothing Then go_Trace.WriteTraceProc True, "A_Seek:DefaultCountry_Let", "as_defaultCountry =" & as_defaultCountry
    #End If
    ms_defaultCountry = as_defaultCountry
    #If CapDebug Then
        If Not go_Trace Is Nothing Then go_Trace.WriteTraceProc False, "A_Seek:DefaultCountry_Let"
    #End If
End Property

Property Let ConnectString(as_ConnectString As String)
    
    #If CapDebug Then
        If Not go_Trace Is Nothing Then go_Trace.WriteTraceProc True, "A_Seek:ConnectString_Let", "as_ConnectString=" & as_ConnectString
    #End If
    CapMouseOff
    
    ms_UID = ConnectionStringValidation(as_ConnectString)
    If ms_UID = "" Then GoTo Trace_End
    
    ms_ConnectString = as_ConnectString
    
Trace_End:
    #If CapDebug Then
        If Not go_Trace Is Nothing Then go_Trace.WriteTraceProc False, "A_Seek:ConnectString_Let"
    #End If
    CapMouseOn
End Property

Property Let Language(ALng As String)
    #If CapDebug Then
        If Not go_Trace Is Nothing Then go_Trace.WriteTraceProc True, "A_Seek:Language_Let", "ALng=" & ALng
    #End If
    CapMouseOff
    
    m_Language = ALng
    
Trace_End:
    #If CapDebug Then
        If Not go_Trace Is Nothing Then go_Trace.WriteTraceProc False, "A_Seek:Language_Let"
    #End If
    CapMouseOn
End Property

Public Property Let Charset(ai_Value As Integer)
  
    #If CompDebugPR Then
        If Not go_Trace Is Nothing Then go_Trace.WriteTraceProc True, "A_Seek:Charset_Let", "ai_Value=" & ai_Value
    #End If
  
    mi_Charset = ai_Value
    txt_search.Font.Charset = mi_Charset

    #If CompDebugPR Then
        If Not go_Trace Is Nothing Then go_Trace.WriteTraceProc False, "A_Seek:Charset_Let"
    #End If
    
End Property

Public Property Get Charset() As Integer
  
    #If CompDebugPR Then
        If Not go_Trace Is Nothing Then go_Trace.WriteTraceProc True, "A_Seek:Charset_Get"
    #End If
  
    Charset = mi_Charset

    #If CompDebugPR Then
        If Not go_Trace Is Nothing Then go_Trace.WriteTraceProc False, "A_Seek:Charset_Get", "Result=" & Charset
    #End If
    
End Property

Property Let Enabled(ATag As Boolean)
    #If CapDebug Then
        If Not go_Trace Is Nothing Then go_Trace.WriteTraceProc True, "A_Seek:Enabled_Let", "ATag=" & ATag
    #End If
    
    txt_search.Enabled = ATag
    bt_search.Enabled = ATag
    
Trace_End:
    #If CapDebug Then
        If Not go_Trace Is Nothing Then go_Trace.WriteTraceProc False, "A_Seek:Enabled_Let"
    #End If
End Property

Property Let ComponentType(as_componentType As String)
    #If CapDebug Then
        If Not go_Trace Is Nothing Then go_Trace.WriteTraceProc True, "A_Seek:ComponentType_Let", "as_componentType=" & as_componentType
    #End If
    
    ms_ComponentType = as_componentType
    
Trace_End:
    #If CapDebug Then
        If Not go_Trace Is Nothing Then go_Trace.WriteTraceProc False, "A_Seek:ComponentType_Let"
    #End If
End Property

Public Sub LetSelectedItem(as_Code As String, as_desc As String)
    #If CapDebug Then
        If Not go_Trace Is Nothing Then go_Trace.WriteTraceProc True, "A_Seek:LetSelectedItem_Let", "as_code=" & as_Code, "as_desc=" & as_desc
    #End If
    
    ms_SelectedItemCode = as_Code
    ms_SelectedItemDesc = as_desc
    If ms_SelectedItemCode <> "" Then
        txt_search.Text = ms_SelectedItemDesc
    End If
    
Trace_End:
    #If CapDebug Then
        If Not go_Trace Is Nothing Then go_Trace.WriteTraceProc False, "A_Seek:LetSelectedItem_Let"
    #End If
End Sub

Public Property Get SelectedItemCode() As String
    #If CapDebug Then
        If Not go_Trace Is Nothing Then go_Trace.WriteTraceProc True, "A_Seek:SelectedItemCode_Get"
    #End If
    
    SelectedItemCode = ms_SelectedItemCode
    
    #If CapDebug Then
        If Not go_Trace Is Nothing Then go_Trace.WriteTraceProc False, "A_Seek:SelectedItemCode_Get", "Result=" & SelectedItemCode
    #End If
End Property

Public Property Get SelectedItemDesc() As String
    #If CapDebug Then
        If Not go_Trace Is Nothing Then go_Trace.WriteTraceProc True, "A_Seek:SelectedItemDesc_Get"
    #End If
    
    SelectedItemDesc = ms_SelectedItemDesc
    
    #If CapDebug Then
        If Not go_Trace Is Nothing Then go_Trace.WriteTraceProc False, "A_Seek:SelectedItemDesc_Get", "Result=" & SelectedItemDesc
    #End If
End Property

Public Sub Clear()
    
    On Error GoTo Trace_Err
    CapMouseOff
    #If CapDebug Then
        If Not go_Trace Is Nothing Then go_Trace.WriteTraceProc True, "A_Seek:Clear"
    #End If
    
    ms_SelectedItemCode = ""
    ms_SelectedItemDesc = ""
    txt_search.Text = ""
    
Trace_End:
    #If CapDebug Then
        If Not go_Trace Is Nothing Then go_Trace.WriteTraceProc False, "A_Seek:Clear"
    #End If
    CapMouseOn
    Exit Sub

Trace_Err:
    If Not go_Trace Is Nothing Then go_Trace.WriteTraceError Err.Number, Err.Description, "A_Seek:Clear"
    CapMouseOn
End Sub

Public Sub Unload_A_COM()

    On Error GoTo Trace_Err
    CapMouseOff
    #If CapDebug Then
        If Not go_Trace Is Nothing Then go_Trace.WriteTraceProc True, "A_Seek:Unload_A_COM"
    #End If
    
    ASC_DisconnectFromDB mo_ArmDb, ms_UID, mb_Created

Trace_End:
    #If CapDebug Then
        If Not go_Trace Is Nothing Then go_Trace.WriteTraceProc False, "A_Seek:Unload_A_COM"
    #End If
    CapMouseOn
    Exit Sub

Trace_Err:
    If Not go_Trace Is Nothing Then go_Trace.WriteTraceError Err.Number, Err.Description, "A_Seek:Unload_A_COM"
    CapMouseOn
End Sub

Private Sub bt_search_Click()
Dim lo_SeekForm As SeekForm

    On Error GoTo Trace_Err
    CapMouseOff
    #If CapDebug Then
        If Not go_Trace Is Nothing Then go_Trace.WriteTraceProc True, "A_Seek:bt_search_Click"
    #End If
    
    Set lo_SeekForm = New SeekForm
    Load lo_SeekForm
    lo_SeekForm.Language = m_Language
    If mb_use_framework_connection = True Then Set lo_SeekForm.ArmDb = mo_ArmDb
    lo_SeekForm.ConnectString = ms_ConnectString
    
    lo_SeekForm.ComponentType = ms_ComponentType
    lo_SeekForm.TreeView_DateType = "0"
    
    If ms_ComponentType = "CUSTOMER" Then
        lo_SeekForm.TreeViewFilters = "" & CH_LDELIMIT & "" & CH_LDELIMIT & "" & CH_LDELIMIT & "''"
    End If
    
    lo_SeekForm.TreeViewFiltersDesc = ""
    
    lo_SeekForm.DefaultCountry = ms_defaultCountry      ' 02/12/2013 JN default country
    
    lo_SeekForm.Load_A_COM
    
    CapMouseOn
    lo_SeekForm.show vbModal
    CapMouseOff
    
    If lo_SeekForm.SelectedData = True Then
        ms_SelectedItemCode = lo_SeekForm.SelectedItemCode
        ms_SelectedItemDesc = lo_SeekForm.SelectedItemDesc
        txt_search.Text = ms_SelectedItemDesc
    End If
    
    lo_SeekForm.Unload_A_COM
    Unload lo_SeekForm
    Set lo_SeekForm = Nothing
    
    RaiseEvent Change

Trace_End:
    #If CapDebug Then
        If Not go_Trace Is Nothing Then go_Trace.WriteTraceProc False, "A_Seek:bt_search_Click"
    #End If
    CapMouseOn
    Exit Sub

Trace_Err:
    If Not go_Trace Is Nothing Then go_Trace.WriteTraceError Err.Number, Err.Description, "A_Seek:bt_search_Click"
    CapMouseOn
End Sub

Public Sub Load_A_COM()
    
    On Error GoTo Trace_Err
    CapMouseOff
    #If CapDebug Then
        If Not go_Trace Is Nothing Then go_Trace.WriteTraceProc True, "A_Seek:Load_A_Com"
    #End If
    
    VerifyInitialization mo_ArmDb, ms_ConnectString, m_Language, Me
    
    Clear
    
    ms_defaultCountry = gs_CaptureCountry
    
Trace_End:
    #If CapDebug Then
        If Not go_Trace Is Nothing Then go_Trace.WriteTraceProc False, "A_Seek:Load_A_Com"
    #End If
    CapMouseOn
    Exit Sub

Trace_Err:
    If Not go_Trace Is Nothing Then go_Trace.WriteTraceError Err.Number, Err.Description, "A_Seek:Load_A_Com"
    CapMouseOn
End Sub

Private Sub txt_search_KeyDown(KeyCode As Integer, Shift As Integer)

    #If CapDebug Then
        If Not go_Trace Is Nothing Then go_Trace.WriteTraceProc True, "A_Seek:txt_search_KeyDown"
    #End If
    
    If KeyCode = 8 Or KeyCode = 46 Then 'Del and Suppr Key
        ms_SelectedItemCode = ""
        ms_SelectedItemDesc = ""
        txt_search.Text = ""
        RaiseEvent Change
    End If

    #If CapDebug Then
        If Not go_Trace Is Nothing Then go_Trace.WriteTraceProc False, "A_Seek:txt_search_KeyDown"
    #End If

End Sub

Private Sub txt_search_KeyPress(KeyAscii As Integer)
    'All key are ignored
    KeyAscii = 0
End Sub

Private Sub UserControl_Resize()
    On Error GoTo Trace_Err
    CapMouseOff
    #If CapDebug Then
        If Not go_Trace Is Nothing Then go_Trace.WriteTraceProc True, "A_Seek:UserControl_Resize"
    #End If
    
    txt_search.Top = 0
    txt_search.Left = 0
    txt_search.Width = UserControl.Width
    bt_search.Left = txt_search.Width - bt_search.Width - 35
    bt_search.Top = 35
    
Trace_End:
    #If CapDebug Then
        If Not go_Trace Is Nothing Then go_Trace.WriteTraceProc False, "A_Seek:UserControl_Resize"
    #End If
    CapMouseOn
    Exit Sub

Trace_Err:
    If Not go_Trace Is Nothing Then go_Trace.WriteTraceError Err.Number, Err.Description, "A_Seek:UserControl_Resize"
    CapMouseOn
End Sub

